{A simple unit to manage write-only sequential access file buffers
 for text files.  It doesn't overwrite files, it appends to them if they
 already exist.}

{$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+,Y+}
Unit TextBuf;

Interface

Const
   MaxBufferSize=64512; {Maximum size of a buffer}
   MaxRecommendedSize=49152;
   CRLFString=#13#10;

Type
   {Buffer types}
   TBuffer=Array[1..MaxBufferSize] of Char;
   PBuffer=^TBuffer;

   {Buffered file types}
   PFile=^TFile;
   TFile=Object
            Private
            F:File;
            BufferSize:Word;
            BufferIndex:Word;
            Buffer:PBuffer;
            FileOpen:Boolean;
            Public
            BufferFull:Boolean;
            Constructor Init(FileName:String; Size:Word);
            Destructor Done;
            Procedure OutChar(C:Char);
            Procedure Out(S:String);
            Procedure OutLn(S:String);
            Procedure NewLine;
            Procedure FlushBuffer;
            Procedure CloseFile;
            Procedure OpenFile;
            Procedure RewriteFile;
         End;

Implementation

Constructor TFile.Init(FileName:String; Size:Word);

Begin
   Assign(F,FileName);
   If MaxAvail<Size Then
      Size:=MaxAvail;
   BufferSize:=Size;
   BufferIndex:=0;
   GetMem(Buffer,Size);
   OpenFile;
End;

Destructor TFile.Done;

Begin
   CloseFile;
End;

Procedure TFile.OutChar(C:Char);

Begin
   If BufferFull Then
      Exit;
   If BufferIndex=BufferSize Then
      FlushBuffer;
   Inc(BufferIndex);
   Buffer^[BufferIndex]:=C;
End;

Procedure TFile.Out(S:String);

Var
   CutOff:Word;

Begin
   If BufferFull Then
      Exit;
   If BufferIndex=BufferSize Then
      FlushBuffer;
   CutOff:=BufferSize-BufferIndex;
   If (Byte(S[0])>CutOff) Then
      Begin
         Move(S[1],Buffer^[BufferIndex+1],CutOff);
         Inc(BufferIndex,CutOff);
         FlushBuffer;
         Delete(S,1,CutOff);
      End;
   Move(S[1],Buffer^[BufferIndex+1],Byte(S[0]));
   Inc(BufferIndex,Byte(S[0]));
End;

Procedure TFile.OutLn(S:String);

Begin
   Out(S);
   NewLine;
End;

Procedure TFile.NewLine;

Begin
   Out(CRLFString);
End;

Procedure TFile.FlushBuffer;

Begin
   If FileOpen Then
      BlockWrite(F,Buffer^,BufferSize)
   Else
      BufferFull:=True;
End;

Procedure TFile.CloseFile;

Begin
   If FileOpen Then
      Begin
         FlushBuffer;
         Close(F);
         FileOpen:=False;
      End;
End;

Procedure TFile.OpenFile;

Begin
   {$I-}
   Reset(F,1);
   {$I+}
   If IOResult<>0 Then
      Rewrite(F,1)
   Else
      Seek(F,FileSize(F));
   FileOpen:=True;
   BufferFull:=False;
End;

Procedure TFile.RewriteFile;

Begin
   Rewrite(F,1);
   FileOpen:=True;
   BufferFull:=False;
   BufferIndex:=0;
End;

End.
