{$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+,Y+}
Unit ParseCPUID;

Interface

Type
   CPUInfoRec=Record
                 EAX,EBX,ECX,EDX:LongInt;
              End;
   TCPU=Object
            Constructor Init(var Data:CPUInfoRec);
            Procedure ConvertData(var Data:CPUInfoRec); virtual;
            Procedure DisplayData; virtual;
            Destructor Done; virtual;
        End;
   PCPU=^TCPU;
   TCPU0=Object(TCPU)
            Private
            MaxLevel:LongInt;
            Vendor:Array[1..12] of Char;
            Public
            Procedure ConvertData(var Data:CPUInfoRec); virtual;
            Procedure DisplayData; virtual;
            Destructor Done; virtual;
         End;
   PCPU0=^TCPU0;
   TCPU1=Object(TCPU)
            Private
            CPUType:Byte;   {2 bits  - 12-13}
            Family:Byte;    {4 bits  -  8-11}
            Model:Byte;     {4 bits  -  4- 8}
            Stepping:Byte;  {4 bits  -  0- 3}
            MMX,
            CMOV,
            MCA,
            PGE,
            MemoryTypeRangeRegs,
            APIC,
            CMPXCHG8B,
            MCE,
            PAE,
            MSRS,
            TSC,
            PSE,
            IOBreakpoints,
            VME,
            FPU:Boolean;
            Public
            Procedure ConvertData(var Data:CPUInfoRec); virtual;
            Procedure DisplayData; virtual;
            Destructor Done; virtual;
         End;
   PCPU1=^TCPU1;
   TCPU2=Object(TCPU)
            Private
            Descriptors:Array[1..16]of Byte;
            Public
            Procedure ConvertData(var Data:CPUInfoRec); virtual;
            Procedure DisplayData; virtual;
            Destructor Done; virtual;
         End;
   PCPU2=^TCPU2;
   TCPUGeneric=Object(TCPU)
                  Private
                  Level,
                  EAX,
                  EBX,
                  ECX,
                  EDX:LongInt;
                  Public
                  Constructor Init(var Data:CPUInfoRec; Index:LongInt);
                  Procedure ConvertData(var Data:CPUInfoRec); virtual;
                  Procedure DisplayData; virtual;
                  Destructor Done; virtual;
               End;
   PCPUGeneric=^TCPUGeneric;

Const
   HighLevel:LongInt=0;

Function ParseInfo(Index:LongInt; var Data:CPUInfoRec):PCPU;

Implementation

{
 CPUID   0F A2     CPU identification
                   in:   EAX=0         get max. identification level and vendor
                   out:  EAX=1/2       max. identification level is 1 or 2 now
                         EBX-EDX-ECX   vendor identification
                           'GenuineIntel' - Intel i486, iPentium or iPentiumPro
                           'UMC UMC UMC ' - UMC U5S or U5D processor
                           'AuthenticAMD' - AMD 486DX2 or DX4 (enh.) processor
                           'CyrixInstead' - Cyrix 6x86 processor
                           'NexGenDriven' - NexGen Nx586 or Nx686 processor
                   in:   EAX=1         get chip type and the supported features
                   out:  EAX=0:TFMS    CPU type (type, family, model, stepping)
                           type        The type is encoded in the bits13/12.
                                       00=1st dual iPentium CPU (iP54C)
                                       01=iPentium OverDrive processor
                                       10=2nd dual iPentium CPU (iP54C)
                                       11=reserved
                           family      4=486, 5=iPentium, 6=iPentiumPro
                           model       Intel486: 0=DX, 1=DX50, 2=SX, 3=DX2,
                                                 4=SL, 5=SX2, 7=DX2WB, 8=DX4,
                                                 9=DX4WB
                                       UMC486:   1=U5D, 2=U5S
                                       AMD486:   3=DX2, 7=DX2WB, 8=DX4, 9=DX4WB
                                                 E=X5WT, F=X5WB
                                       Cyrix:    9=Cyrix 5x86
                                       iPentium: 0=5V-60/66 MHz A-step chips,
                                                 1=5V-60/66 MHz, 2=3.3V-75/90/
                                                 100/120/133MHz, 3=P24T, 4=OvDr
                                                 for iPentium-3.3V, 5=OvDr for
                                                 iDX4, 6=OvDr for iPentium-5V
                                       Nx586:    0=newer Nx586 or Nx586FPU
                                       Cyrix:    2,3=Cyrix 6x86
                                       AMD K5:   0=SSA5, 1=5k86
                                       iPentPro: 0=iPentiumPro A-step chips,
                                                 1=iPentiumPro, 4=P55CT iP54C
                                                 socket OverDrive (droped?)
                           stepping    steppings sometimes cover several masks
                           comment     iPentium-5V: no fDIVbug since step no.7
                                       iPentium-3V: no fDIVbug since step no.4
                         EDX=flags     supported features (i486, iPentium, iP6)
                           bit31..24   reserved (=0)
                           bit23=1     MMX (multi media instructions) supported
                           bit22..16   reserved (=0)
                           bit15=1     CMOVcc (and FCMOVcc/FCOMI) supported
                           bit14=1     machine check architecture supported
                           bit13=1     page global enable supported
                           bit12=1     memory type range registers supported
                           bit11=0     reserved
                           bit10=0     reserved
                           bit9=1      CPU contains an enabled local APIC
                                       page global enable supported? (AMD K5)
                           bit8=1      CMPXCHG8B instruction supported
                           bit7=1      machine check exception supported
                           bit6=1      physical address extension supported
                           bit5=1      iPentium-style MSRs supported
                           bit4=1      time stamp counter TSC supported
                           bit3=1      page size extensions supported
                           bit2=1      I/O breakpoints supported
                           bit1=1      enhanced virtual 8086 mode supported
                           bit0=1      CPU contains a floating-point unit (FPU)
                   in:   EAX=2         get cache configuration descriptors
                   out:  AL=01h        configuration descriptors are valid
                         AL<>1         reserved for future use
                         EAX..EDX      4x4 8bit configuration descriptors
                           00h=null descriptor (=unused descriptor)
                           01h=code TLB, 4K pages, 4 ways, 64 entries
                           02h=code TLB, 4M pages, 4 ways, 4 entries
                           03h=data TLB, 4K pages, 4 ways, 64 entries
                           04h=data TLB, 4M pages, 4 ways, 8 entries
                           06h=code L1 cache, 8KB, 4 ways, 32 byte lines
                           0Ah=data L1 cache, 8KB, 2 ways, 32 byte lines
                           41h=c+d L2 cache, 128KB, 4 ways, 32 byte lines
                           42h=c+d L2 cache, 256KB, 4 ways, 32 byte lines
                           43h=c+d L2 cache, 512KB, 4 ways, 32 byte lines
                           xxh=other values are reserved for future use
                           A descriptor is only valid if its highest bit is 0!
                         EAX=03020101h on an iPentiumPro (example)
                         EBX=00000000h on an iPentiumPro (example)
                         ECX=00000000h on an iPentiumPro (example)
                         EDX=06040A42h on an iPentiumPro (example)
                           Because AL is 01h, the descriptors are valid. All of
                           the descriptors are valid, because their highest bit
                           is 0. This iPentiumPro includes the 4K/M c/d TLB, an
                           8+8 KB c/d L1 cache and a 256 KB c+d L2 cache.
                   in:   EAX>maximum   max. supported CPUID level can be higher
                                       than the max. returned level from CPUID,
                                       so hidden levels are not impossible now!
                   out:  undefined     EAX, EBX, ECX, EDX values are undefined
                   info: can be used in all CPLs; serializes the pipelines; the
                         A-step iPentiums  did not support several CPUID levels
                         and they show EAX=FMS and EBX-EDX-ECX=vendor only! (so
                         they seem to provide more than 500h CPUID levels); bug
                         in i486DX2 processor? (level #2..7FFFFFFFh=zero, level
                         #80000000..FFFFFFFFh=as level #1; has no side effect),
                         this bug is not present in the i486DX2WB processor
}

Uses
   StrProcs;

Const
   Yes='Yes';
   No ='No ';

Procedure Abstract;

Begin
   RunError(211);
End;

Constructor TCPU.Init(var Data:CPUInfoRec);

Begin
   ConvertData(Data);
End;

Procedure TCPU.ConvertData(var Data:CPUInfoRec);

Begin
   Abstract;
End;

Procedure TCPU.DisplayData;

Begin
   Abstract;
End;

Destructor TCPU.Done;

Begin
End;

Procedure TCPU0.ConvertData(var Data:CPUInfoRec);

Type
   NameCast=Array[1..3] of LongInt;

Begin
   With Data Do
      Begin
         MaxLevel:=EAX;
         HighLevel:=MaxLevel;
         NameCast(Vendor)[1]:=EBX;
         NameCast(Vendor)[2]:=EDX;
         NameCast(Vendor)[3]:=ECX;
      End;
End;

Procedure TCPU0.DisplayData;

Var
   Loop:Byte;

Begin
   Writeln('CPUID Information - Level 00000000h'#13#10+
           '-----------------------------------');
   Write  ('Maximum CPUID Level : ');
   Writeln(HexLong(MaxLevel),'h');
   Write  ('Vendor String       : ');
   For Loop:=1 to 12 Do
      Write(Vendor[Loop]);
   Writeln;
End;

Destructor TCPU0.Done;

Begin
End;

Procedure TCPU1.ConvertData(var Data:CPUInfoRec);

Begin
   With Data Do
      Begin
         CPUType:=((EAX shr 12) and $03);
         Family:=((EAX shr 8) and $0F);
         Model:=((EAX shr 4) and $0F);
         Stepping:=(EAX and $0F);
         MMX:=Boolean((EDX shr 23) and 1);
         CMOV:=Boolean((EDX shr 15) and 1);
         MCA:=Boolean((EDX shr 14) and 1);
         PGE:=Boolean((EDX shr 13) and 1);
         MemoryTypeRangeRegs:=Boolean((EDX shr 12) and 1);
         APIC:=Boolean((EDX shr 9) and 1);
         CMPXCHG8B:=Boolean((EDX shr 8) and 1);
         MCE:=Boolean((EDX shr 7) and 1);
         PAE:=Boolean((EDX shr 6) and 1);
         MSRS:=Boolean((EDX shr 5) and 1);
         TSC:=Boolean((EDX shr 4) and 1);
         PSE:=Boolean((EDX shr 3) and 1);
         IOBreakpoints:=Boolean((EDX shr 2) and 1);
         VME:=Boolean((EDX shr 1) and 1);
         FPU:=Boolean(EDX and 1);
      End;
End;

Procedure TCPU1.DisplayData;

Begin
   Writeln('CPUID Information - Level 00000001h'#13#10+
           '-----------------------------------');
   Writeln;
   Writeln('CPU Type');
   Writeln('--------------------------------------------------------------');
   Write  ('Type     : ',HexByte(CPUType),'h');
   Write  ('  Family   : ',HexByte(Family),'h');
   Write  ('  Model    : ',HexByte(Model),'h');
   Writeln('  Stepping : ',HexByte(Stepping),'h');
   Writeln;
   Writeln('Extra Instructions                      Paging Extensions');
   Writeln('--------------------------------        -------------------------------');
   Write  ('CMOV      : '); If CMOV Then Write(Yes) Else Write(No);
   Write  ('  CMPXCHG8B : '); If CMPXCHG8B Then Write(Yes) Else Write(No);
   Write  ('        PGE : '); If PGE Then Write(Yes) Else Write(No);
   Write  ('  PAE : '); If PAE Then Write(Yes) Else Write(No);
   Write  ('  PSE : '); If PSE Then Write(Yes) Else Write(No);
   Writeln;
   Writeln;
   Writeln('Extra Registers                         Hardware Features');
   Writeln('---------------------------------       ---------------------');
   Write  ('MMx  : '); If MMX Then Write(Yes) Else Write(No);
   Write  ('  MSRs : '); If MSRS Then Write(Yes) Else Write(No);
   Write  ('  TSC : '); If TSC Then Write(Yes) Else Write(No);
   Write  ('       APIC : '); If APIC Then Write(Yes) Else Write(No);
   Write  ('  FPU : ');  If FPU Then Write(Yes) Else Write(No);
   Writeln;
   Write  ('Memory Type Range Registers : ');
      If MemoryTypeRangeRegs Then Write(Yes) Else Write(No);
   Writeln;
   Writeln;
   Writeln('Machine Check Options                   Protected Mode Extensions');
   Writeln('---------------------                   --------------------------------');
   Write  ('MCA : ');               If MCA Then Write(Yes) Else Write(No);
   Write  ('  MCE : ');               If MCE Then Write(Yes) Else Write(No);
   Write  ('                  ');
   Write  ('  VME : '); If VME Then Write(Yes) Else Write(No);
   Write  ('  I/O Breakpoints : '); If IOBreakpoints Then Write(Yes) Else Write(No);
   Writeln;
End;

Destructor TCPU1.Done;

Begin
End;

Procedure TCPU2.ConvertData(var Data:CPUInfoRec);

Type
   DescCast=Array[1..4] of LongInt;

Begin
   With Data Do
      Begin
         DescCast(Descriptors)[1]:=EAX;
         DescCast(Descriptors)[2]:=EBX;
         DescCast(Descriptors)[3]:=ECX;
         DescCast(Descriptors)[4]:=EDX;
      End;
End;

Procedure TCPU2.DisplayData;

Var
   Loop:Byte;

Begin
   Write  ('CPUID Information - Level 00000002h'#13#10+
           '-----------------------------------'#13#10+
           'Valid Config Descriptors : ');
   If Descriptors[1]=1 Then
      Begin
         Writeln(Yes);
         Writeln;
         Writeln('Configuration Descriptors');
         Writeln('-------------------------');
         For Loop:=2 to 15 Do
            If (Descriptors[Loop]>$80) Then {if bit 7 set, invalid}
               Writeln('Invalid descriptor!')
            Else
               Case Descriptors[Loop] of
                  $00 : ;
                  $01 : Writeln('code TLB, 4K pages, 4 ways, 64 entries');
                  $02 : Writeln('code TLB, 4M pages, 4 ways, 4 entries');
                  $03 : Writeln('data TLB, 4K pages, 4 ways, 64 entries');
                  $04 : Writeln('data TLB, 4M pages, 4 ways, 8 entries');
                  $06 : Writeln('code L1 cache, 8KB, 4 ways, 32 byte lines');
                  $0A : Writeln('data L1 cache, 8KB, 2 ways, 32 byte lines');
                  $41 : Writeln('c+d L2 cache, 128KB, 4 ways, 32 byte lines');
                  $42 : Writeln('c+d L2 cache, 256KB, 4 ways, 32 byte lines');
                  $43 : Writeln('c+d L2 cache, 512KB, 4 ways, 32 byte lines');
               Else
                  Writeln('Reserved value!');
               End;
      End
   Else
      Writeln(No);
End;

Destructor TCPU2.Done;

Begin
End;

Constructor TCPUGeneric.Init(var Data:CPUInfoRec; Index:LongInt);

Begin
   inherited Init(Data);
   Level:=Index;
End;

Procedure TCPUGeneric.ConvertData(var Data:CPUInfoRec);

Begin
   EAX:=Data.EAX;
   EBX:=Data.EBX;
   ECX:=Data.ECX;
   EDX:=Data.EDX;
End;

Procedure TCPUGeneric.DisplayData;

Type
   CharArray=Array[1..4] of Char;

Var
   Loop:Byte;

Begin
   Writeln('CPUID Information - Level ',HexLong(Level),'h');
   Writeln('-----------------------------------');
   Writeln;
   Writeln('Register Dump:');
   Writeln;
   Writeln('Reg  Hex       Decimal     Binary                            Char');
   Writeln('---  --------  ----------  --------------------------------  ----');
   Write  ('EAX  ',HexLong(EAX),'  ',EAX:10,'  ',BinLong(EAX),'  ');
      For Loop:=1 to 4 Do
         If (CharArray(EAX)[Loop]<#32) Then
            Write('.')
         Else
            Write(CharArray(EAX)[Loop]);
      Writeln;
   Write  ('EBX  ',HexLong(EBX),'  ',EBX:10,'  ',BinLong(EBX),'  ');
      For Loop:=1 to 4 Do
         If (CharArray(EBX)[Loop]<#32) Then
            Write('.')
         Else
            Write(CharArray(EBX)[Loop]);
      Writeln;
   Write  ('ECX  ',HexLong(ECX),'  ',ECX:10,'  ',BinLong(ECX),'  ');
      For Loop:=1 to 4 Do
         If (CharArray(ECX)[Loop]<#32) Then
            Write('.')
         Else
            Write(CharArray(ECX)[Loop]);
      Writeln;
   Write  ('EDX  ',HexLong(EDX),'  ',EDX:10,'  ',BinLong(EDX),'  ');
      For Loop:=1 to 4 Do
         If (CharArray(EDX)[Loop]<#32) Then
            Write('.')
         Else
            Write(CharArray(EDX)[Loop]);
      Writeln;
End;

Destructor TCPUGeneric.Done;

Begin
End;

Function ParseInfo(Index:LongInt; var Data:CPUInfoRec):PCPU;

Begin
   Case Index of
      0 : ParseInfo:=New(PCPU0,Init(Data));
      1 : ParseInfo:=New(PCPU1,Init(Data));
      2 : ParseInfo:=New(PCPU2,Init(Data));
   Else
      ParseInfo:=New(PCPUGeneric,Init(Data,Index));
   End;
End;

End.
