{CPUINFO - utility that uses CPUID to find out neat-o stuff.
 Written by John Baldwin, 1996}

{$A+,B-,D+,E-,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V-,X+,Y+}
{$M 4096,16384,16384}
Program CPUInformation;

Uses
   Crt,ParseCPUID;

Var
   Current:PCPU;
   Regs:CPUInfoRec;
   Loop:LongInt;

{$L CPUINFO}
Function CPUIDThere:Boolean; Far; External;
Procedure RunCPUID(Index:LongInt; var Data:CPUInfoRec); Far; External;

Procedure ShowCurrent;

Begin
   ClrScr;
   Current^.DisplayData;
   Writeln;
   Writeln('Press Enter...');
   Readln;
End;

Procedure DisplayLevel(Level:LongInt);

Begin
   RunCPUID(Level,Regs);
   Current:=ParseInfo(Level,Regs);
   ShowCurrent;
   Dispose(Current,Done);
End;


Begin
   Writeln('CPU Info v1.0 - Written by John Baldwin.');
   Writeln;
   Writeln('Thanks to Christian Ludloff, whose 4P package was used as the source of all the');
   Writeln('information for this program, specifically the file 80x86.CPU.');
   Writeln;
   If CPUIDThere Then
      Begin
         Writeln('You got CPUID on here, so let''s see what this puppy can do.');
         Writeln;
         Writeln('Hit Enter to start...');
         Readln;
         DisplayLevel(0);  {Always there and initializes HighLevel}
         For Loop:=1 to HighLevel Do
            DisplayLevel(Loop);
      End
   Else
      Writeln('You ain''t got CPUID.  And I don''t feel like resetting the processor to find'#13#10+
              'out what kind of computer this is, but I can tell you that if you got this far'#13#10+
              'then you have a 386.');
End.