//Program to analyze GDT for BIOSINFO

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include "biosinfo.h"

#define GDT_ENTRIES  10
#define DoubleLine   ""
#define SingleLine   ""

//Descriptor structure
struct Descriptor
{
 unsigned short SegmentLimitLow;      //low 16 bits of segment limit (size)
 unsigned short SegmentBaseLow;       //low 24 bits of segment base linear address
 unsigned char  SegmentBaseLow2;
 unsigned char  TypeFlags;            //segment type-specific flags (Mem Flags, Sys Flags)
 unsigned char  GeneralFlags;         //segment-general flags (Seg Flags)
 unsigned char  SegmentBaseHigh;      //high 8 bits of segment base linear address
};

//Structure of a DT descriptor (descriptor table descriptor)
struct DescTableDescriptor
{
 unsigned short TableSize;            //size of table in bytes, max 64k
 unsigned long  TableAddress;         //physical address of table
};

Descriptor far * GDT;
DescTableDescriptor far * GDT_Desc;

extern "C" {
   unsigned short far pascal GetCS(void);
   unsigned short far pascal GetSS(void);
   unsigned short far pascal GetDS(void);
   Descriptor far * far pascal GetGDT(void);
   DescTableDescriptor far * far pascal GetGDT_Desc(void);
}

const char SelectorNames[GDT_ENTRIES-1][20] = { "Code - PM32","Data - 1M Flat",
                                                "Data - Internal","Stack",
                                                "Code - 1M Flat",
                                                "Code - BIOS32",
                                                "Data - BIOS32",
                                                "Video Segment", 
                                                "Code - PM16",};

const char SelTypes[8][5] = { "Ro","RW","RoEd","RWEd",
                              "Xo","XR","XoC" ,"XRC" };

void Pause(void)

{
   printf("Press Enter to continue...");
   while(getch()!='\r');
};

void ClearScreen(void)
{
   asm {
      mov ax,0x0003
      int 0x10
   };
};

void ClearScreenBig(void)
{
   asm {
      mov ax,0x0003
      int 0x10
      mov ax,0x1112
      xor bl,bl
      int 0x10          //80x50
      mov ax,0x40
      mov bx,0x84
      mov es,ax
      mov [BYTE PTR es:bx],49
   };
};

void Init()
{
   ClearScreen();
   printf("GDT Check v1.0 - Written by John Baldwin\n");
   printf(DoubleLine);
   printf("\n\n");
   if(CheckForPM())
      {
         printf("You are already in Protected Mode!\n");
         exit(1);
      }
};

void DumpGDT()
{
   int loop;
   unsigned long temp;

   ClearScreenBig();
   printf("GDT Check v1.0 - Written by John Baldwin\n");
   printf(DoubleLine);
   printf("\n\n");
   GDT=GetGDT();
   GDT_Desc=GetGDT_Desc();
   printf("GDT_DT: Address -> %08lXh\n",GDT_Desc->TableAddress);
   printf("        Size    ->     %04Xh\n",GDT_Desc->TableSize);
   printf("\n");
   printf("GDT: 0000h -> Null Selector (Invalid)\n");
   for(loop=1; loop<GDT_ENTRIES; loop++)
      {
         printf("     %04Xh -> %s\n",loop<<3,SelectorNames[loop-1]);
         temp=(GDT[loop].SegmentBaseHigh<<8)+
              GDT[loop].SegmentBaseLow2;
         temp=temp<<16;
         temp+=GDT[loop].SegmentBaseLow;
         printf("              Base   -> %08lXh\n",temp);
         temp=GDT[loop].GeneralFlags & 0xF;
         temp=temp<<16;
         temp+=GDT[loop].SegmentLimitLow;
         printf("              Limit  ->    %05lXh\n",temp);
         printf("              Flags  -> ");
         if(GDT[loop].TypeFlags & 0x10)
            printf("Mem %s ",SelTypes[(GDT[loop].TypeFlags & 0xE)>>1]);
         else
            printf("Sys ");
         if(GDT[loop].GeneralFlags & 0x80)
            printf("Page-Granular ");
         else
            printf("Byte-Granular ");
         if(GDT[loop].GeneralFlags & 0x40)
            printf("32-bit ");
         else
            printf("16-bit ");
         printf("\n");
      }
   printf("\nRegisters: CS %04X  DS %04X  SS %04X\n",GetCS(),GetDS(),GetSS());
};

void main()
{
   Init();
   GetBIOSInfo();
   Pause();
   DumpGDT();
};
