//interface for BIOSINFO.ASM

#define False      0
#define True       1

/////////////////////////////////////////////////////////////////////

//default Pascal-like types

typedef unsigned char Byte;
typedef unsigned char Boolean;
typedef unsigned short Word;
typedef signed long LongInt;
typedef void far * Pointer;

/////////////////////////////////////////////////////////////////////

//BIOSInfo structures

struct TBIOS32Data
{
   char    Signature[4]; //"_32_"
   Pointer EntryPoint;
   Byte    RevisionLevel;
   Byte    Length;
   Byte    CheckSum;
   Byte    Reserved[6];
};

typedef TBIOS32Data far * PBIOS32Data;

struct TBIOS32ServiceEntry
{
   Pointer Base;
   LongInt Length;
   Pointer EntryPoint;
};

typedef TBIOS32ServiceEntry far * PBIOS32ServiceEntry;

struct TPnPInfo
{
   char    Signature[4];  //"$PnP"
   Byte    Version;        //Packed BCD format
   Byte    Length;
   Word    ControlField;
   Byte    CheckSum;
   Pointer EventNotifyFlag;
   Pointer RealModeEntryPoint;
   Word    PM16EntryOffset;
   Pointer PM16EntrySegBase;
   LongInt OEMDeviceID;
   Word    RealModeDataSeg;
   Pointer PM16DataSegBase;
};

typedef TPnPInfo far * PPnPInfo;

struct TBIOSDataTable
{
   Pointer             BIOS32Location;
   Pointer             PnPLocation;
   TBIOS32ServiceEntry PCIInfo;
   TBIOS32ServiceEntry ACFInfo;
};

typedef TBIOSDataTable far * PBIOSDataTable;

/////////////////////////////////////////////////////////////////////

//prototypes

#ifdef __cplusplus
extern "C" {
#endif

PBIOSDataTable far pascal GetBIOSInfo(void);
Pointer        far pascal ConvertFlatToReal(Pointer);
Boolean        far pascal CheckForPM(void);

#ifdef __cplusplus
}
#endif
