;BIOS Info v1.0 - written by John Baldwin, 1997
;Detects the presence of PnP, BIOS32, and a few other odds and ends

StackSize EQU     16384                 ;16k stack

MODEL     Large
IDEAL
P386

BIOS32LOC EQU     0F92F0h

INCLUDE   "..\PMODE\PMODES.INC"
INCLUDE   "BIOS32S.INC"
INCLUDE   "PCIS.INC"
INCLUDE   "PNPS.INC"
INCLUDE   "..\VIDEO\PMTEXT.INC"

;I/O Ports

MasterPIC EQU     021h
SlavePIC  EQU     0A1h
IODelay   EQU     0EDh

;Selectors

Sel_Null  EQU     0000000000000000b
Sel_CSeg  EQU     0000000000001000b
Sel_DSeg  EQU     0000000000010000b
Sel_ESeg  EQU     0000000000011000b
Sel_SSeg  EQU     0000000000100000b
Sel_FlatCS EQU    0000000000101000b
Sel_B32CS EQU     0000000000110000b
Sel_B32DS EQU     0000000000111000b
Sel_Video EQU     0000000001000000b
Sel_CS16  EQU     0000000001001000b

GROUP     CodeGroup _TEXT32, _TEXT16

ASSUME    CS:CodeGroup, DS:_PMDATA

SEGMENT   _PMDATA Word  Public 'PMDATA'

;Here we setup the GDT.
; Entry    Description
;   0     Empty - null descriptor
;   1     Code Segment: describes program CS - execute/read
;   2     Data Segment: Base=0 Limit=1 meg   - read/write
;   3     Extra data: points to internal data area where data such as PnP info,
;         BIOS32 info, and PCI info is stored.
;   4     Stack Segment: describes program's stack
;   5     Flat CS: Base=0 Limit=1 meg - execute/read
;   6     CS for PCI BIOS32: execute only
;   7     DS for PCI BIOS32: read only
;   8     Video Segment

GDT       Descriptor  <>                                  ;null descriptor
CodeS     Descriptor  <0FFFFh,0,0,10011010b,01000000b,0>  ;code segment
          Descriptor  <0FFFFh,0,0,10010010b,00001111b,0>  ;flat DS
ExtraSeg  Descriptor  <0FFFFh,0,0,10010010b,00000000b,0>  ;extra DS
StackSeg  Descriptor  <0FFFFh,0,0,10010010b,00000000b,0>  ;PM SS
          Descriptor  <0FFFFh,0,0,10011010b,01001111b,0>  ;flat CS
PCI_CSeg  Descriptor  <0     ,0,0,10011000b,01000000b,0>  ;PCI BIOS32 CS
PCI_DSeg  Descriptor  <0     ,0,0,10010000b,00000000b,0>  ;PCI BIOS32 DS
VideoSeg  Descriptor  <0FFFFh,0,0,10010010b,00000000b,0>  ;Video Segment
CodeS16   Descriptor  <0FFFFh,0,0,10011010b,00000000b,0>  ;PM16 code segment

GDT_Len   =       $-GDT

LABEL     GDT_PTR FWORD
GDT_Desc  DescTableDescriptor <GDT_Len,0>

LABEL     StartData

;data used by external programs

BIOS32Location DD 0
PnPLocation    DD 0
PCIInfo        BIOS32_ServiceEntry <0,0,0>
ACFInfo        BIOS32_ServiceEntry <0,0,0>

;internal data used to keep us out of trouble whilst jumping in and out of PM

LABEL     BIOS32_Service FWORD

BIOS32Offset   DD 0
BIOS32Sel      DW Sel_FlatCS

SaveMasterPIC  DB ?
SaveSlavePIC   DB ?
SaveSP         DW ?
SaveSS         DW ?

;Here we have strings that we display to the screen

Mesg_Start     DB 10,"Successfully entered PM32. :)",10,0
Mesg_BIOS32    DB "Querying for BIOS32 directory...",10,0
Mesg_PCI       DB "Asking about the PCI BIOS32 service...",10,0
Mesg_ACF       DB "Asking about the PnP ACF BIOS32 service...",10,0
Mesg_PnP       DB "Asking about the Plug 'n' Play BIOS extension...",10,0
Mesg_Bye       DB "Going back to real mode...",10,0
Mesg_Real      DB 13,10,10,10,10,10,10,10,"Back in real mode...",13,10,"$"

ENDS

SEGMENT   _PMSTACK Word Private 'PMSTACK'

          DB      StackSize DUP(?)

ENDS

SEGMENT   _TEXT32 Byte  Public Use32 'CODE'

MACRO     Delay
LOCAL     @@Delay

          mov     ecx,166666667         ;166 MHz = 1 second
@@Delay:  loop    @@Delay

ENDM

;Call with: EAX=4 byte signature
;           ESI=start address
;           EDI=stop address
;Returns:   CF =status
;              Set = not found
;                 EBX >= EDI
;              Clear = found
;                 EBX=offset of signature
;
;searches on 16 byte boundaries

PROC      FindSig NEAR

          mov     ebx,esi
          and     bl,0F0h               ;make sure on 16-byte boundary
          jmp     SHORT @@Start
@@Loop:   add     ebx,10h
          cmp     ebx,edi
          ja      @@Nope
@@Start:  cmp     [es:ebx],eax
          jne     @@Loop
          clc
          retn
@@Nope:   stc
          retn

ENDP

PROC      GetBIOS32Info NEAR

          mov     edx,BIOS32LOC
          jmp     @@Good
          mov     edx,BIOS32_START_SEARCH
          mov     edi,BIOS32_STOP_SEARCH
@@Search: mov     eax,BIOS32_SIGNATURE
          mov     esi,edx
          call    FindSig
          jnc     @@Good
          retn
@@Test:   mov     edx,ebx               ;save EBX in EDX
          xor     ecx,ecx               ;clear ECX
          mov     al,cl                 ;clear AL
          mov     cl,[es:ebx+9]         ;CL= number of para's in structure
          shl     ecx,4                 ;multiply by 16 to get number of bytes
@@AddLoop: add    al,[es:ebx]           ;add a byte to al
          inc     ebx                   ;go to the next byte
          loop    @@AddLoop             ;add up the whole structure
          or      al,al                 ;see if the checksum matches
          jz      @@Good
          add     edx,10h               ;else skip to next paragraph,
          jmp     SHORT @@Search        ;and keep looking
@@Good:   mov     [BIOS32Location],edx  ;save location of table
          mov     edx,[es:edx+4]        ;get offset of BIOS32 service function
          mov     [BIOS32Offset],edx    ;save to use in calling BIOS32
                                        ;Service function
          retn

ENDP

;Call with: EAX=4 byte signature
;
;Returns:   AL = Status
;              0 = Succesful
;                  EBX = Service Base
;                  ECX = Service Length
;                  EDX = Service Entry Point
;              !0 = Fail
;                   EDX = 0

PROC      GetBIOS32ServiceInfo NEAR

          mov     edx,[BIOS32Offset]    ;EDX = offset of BIOS 32 info
          or      edx,edx               ;see if it is zero (i.e. no BIOS32)
          jnz     @@BIOSOk
          retn
@@BIOSOk: xor     bl,bl                 ;function 0 => get info
          call    [BIOS32_Service]      ;far call to routine
          Delay
          retn

ENDP

PROC      GetPCIBIOSInfo NEAR

          mov     eax,BIOS32_PCI_ID     ;looking for PCI BIOS info
          call    GetBIOS32ServiceInfo
          or      al,al                 ;AL = zero means success
          jz      @@CallOk
          retn
@@CallOk: mov     [PCIInfo.Base],ebx
          mov     [PCIInfo.Length],ecx
          mov     [PCIInfo.EntryPoint],edx

;here would be room to use Sel_B32CS & Sel_B32DS to call at least the
;PCI Function PCI_BIOS_PRESENT to get more detailed info on the PCI BIOS

          retn

ENDP

PROC      GetACFPnPBIOSInfo NEAR

          mov     eax,BIOS32_ACF_ID     ;looking for PCI BIOS info
          call    GetBIOS32ServiceInfo
          or      al,al                 ;AL = zero means success
          jz      @@CallOk
          retn
@@CallOk: mov     [ACFInfo.Base],ebx
          mov     [ACFInfo.Length],ecx
          mov     [ACFInfo.EntryPoint],edx
          retn

ENDP

PROC      GetPnPInfo NEAR

          mov     edx,PnP_START_SEARCH
@@Search: mov     eax,PnP_SIGNATURE
          mov     esi,edx
          mov     edi,PnP_STOP_SEARCH
          call    FindSig
          jnc     @@Good                ;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
          retn
@@Test:   mov     edx,ebx               ;save EBX in EDX
          xor     ecx,ecx               ;clear ECX
          mov     al,cl                 ;clear AL
          mov     cl,[es:ebx+5]         ;CL= number of para's in structure
@@AddLoop: add    al,[es:ebx]           ;add a byte to al
          inc     ebx                   ;go to the next byte
          loop    @@AddLoop             ;add up the whole structure
          or      al,al                 ;see if the checksum matches
          jz      @@Good
          add     edx,10h               ;else skip to next paragraph,
          jmp     SHORT @@Search        ;and keep looking
@@Good:   mov     [PnPLocation],edx     ;save location of table
          retn

ENDP

PROC      InitVideo NEAR

          mov     ax,Sel_Video
          mov     ecx,80
          mov     edx,25
          call    VideoInit
          retn

ENDP

PROC      DoStuffInPM NEAR

          call    InitVideo
          xor     ecx,ecx
          mov     edx,10
          call    SetXY
          mov     ax,Sel_ESeg
          mov     fs,ax
          mov     esi,OFFSET Mesg_Start
          call    PrintLine
          mov     esi,OFFSET Mesg_BIOS32
;         call    PrintLine
          mov     ax,Sel_ESeg
          mov     ds,ax
;         call    GetBIOS32Info
          mov     esi,OFFSET Mesg_PCI
;         call    PrintLine
;         call    GetPCIBIOSInfo
          mov     esi,OFFSET Mesg_ACF
;         call    PrintLine
;         call    GetACFPnPBIOSInfo
          mov     esi,OFFSET Mesg_PnP
;         call    PrintLine
;         mov     ax,Sel_ESeg
;         mov     ds,ax
;         call    GetPnPInfo
          mov     esi,OFFSET Mesg_Bye
;         call    PrintLine
          db      0EAh
          dd      OFFSET ExitPM
          dw      Sel_CS16

ENDP

ENDS

SEGMENT   _TEXT16 Word  Public Use16 'CODE'

ExitPM:   mov     ax,Sel_ESeg
          mov     es,ax
          mov     fs,ax
          mov     gs,ax
;         mov     ss,ax
          mov     eax,cr0
          xor     eax,eax               ;clear bit 0, (i.e. leave PM)
          mov     cr0,eax               ;leave protected mode
;         jmp     FAR CleanUp
          db      0EAh                  ;jmp     far CleanUp
          dw      OFFSET CleanUp
          dw      CodeGroup

PUBLIC    GetBIOSInfo                   ;Function GetBIOSInfo:PBIOSDataTable;
                                        ;PBIOSTable far pascal GetBIOSInfo(void);
PUBLIC    ConvertFlatToReal             ;Function ConvertFlatToReal(P:Pointer):Pointer;
                                        ;Pointer far pascal ConvertFlatToReal(Pointer);
PUBLIC    CheckForPM                    ;Function CheckForPM:Boolean;
                                        ;Boolean far pascal CheckForPM(void);

PUBLIC    GetCS
PUBLIC    GetSS
PUBLIC    GetDS
PUBLIC    GetGDT
PUBLIC    GetGDT_Desc

PROC      SavePICMasks NEAR

          push    ax
          in      al,MasterPIC
          mov     [SaveMasterPIC],al
          out     IODelay,ax
          in      al,SlavePIC
          mov     [SaveSlavePIC],al
          pop     ax
          retn

ENDP

PROC      RestorePICMasks NEAR

          pushf
          cli
          push    ax
          mov     al,[SaveMasterPIC]
          out     MasterPIC,al
          out     IODelay,ax
          mov     al,[SaveSlavePIC]
          out     SlavePIC,al
          pop     ax
          popf
          retn

ENDP

PROC      GetBIOSInfo FAR

          xor     eax,eax
          mov     ax,_PMDATA
          mov     ds,ax
          shl     eax,4               ;multiply EAX by 16 to convert the segment to a
                                      ;physical address
          mov     ebx,OFFSET GDT      ;GDT not necessarily at DS:0 as I had
                                      ;originally assumed
          add     ebx,eax
          mov     [GDT_Desc.TableAddress],ebx
          mov     [ExtraSeg.SegmentBaseLow],ax
          shr     eax,16
          mov     [ExtraSeg.SegmentBaseLow2],al
          mov     [ExtraSeg.SegmentBaseHigh],ah
;         xor     eax,eax             ;unneeded because of shr eax,16 above
          mov     ax,_PMSTACK
          shl     eax,4
          mov     [StackSeg.SegmentBaseLow],ax
          shr     eax,16
          mov     [StackSeg.SegmentBaseLow2],al
          mov     [StackSeg.SegmentBaseHigh],ah
;         xor     eax,eax
          mov     ax,cs
          shl     eax,4
          mov     [CodeS.SegmentBaseLow],ax
          mov     [CodeS16.SegmentBaseLow],ax
          shr     eax,16
          mov     [CodeS.SegmentBaseLow2],al
          mov     [CodeS.SegmentBaseHigh],ah
          mov     [CodeS16.SegmentBaseLow2],al
          mov     [CodeS16.SegmentBaseHigh],ah
          mov     eax,TEXT_SEG_BASE
          mov     [VideoSeg.SegmentBaseLow],ax
          shr     eax,16
          mov     [VideoSeg.SegmentBaseLow2],al
          mov     [VideoSeg.SegmentBaseHigh],ah
          mov     [VideoSeg.SegmentLimitLow],TEXT_SEG_LIMIT
          lgdt    [GDT_PTR]
          pushf
          cli
;         call    SavePICMasks
          mov     [SaveSS],ss
          mov     [SaveSP],sp           ;save SS:SP
          mov     esp,StackSize         ;set up ESP
          xor     bx,bx
          mov     ax,Sel_DSeg           ;selector 2 in GDT with PL0
          mov     fs,bx                 ;FS -> null descriptor
          mov     es,ax                 ;ES -> Base=0 Limit=1 Meg
          mov     gs,bx                 ;GS -> null descriptor
          mov     ax,Sel_ESeg           ;selector 3 in GDT with PL0
          mov     ds,ax                 ;DS -> Base=DataSeg Limit=length of DataSeg
          mov     ax,Sel_SSeg           ;selector 4 in GDT with PL0
          mov     ss,ax                 ;SS -> Base=Stack  Limit=length of Stack
          mov     eax,cr0
          or      al,1
          mov     cr0,eax               ;enter PM
          db      66h,67h,0EAh          ;far 48-bit JMP to start of 32-bit code
          dd      OFFSET DoStuffInPM
          dw      Sel_CSeg

;ENDP

;PROC      CleanUp FAR

CleanUp:  mov     ax,_PMDATA
          mov     ds,ax                 ;restore DS
          lss     sp,[DWORD PTR OFFSET SaveSP] ;restore SS:SP
;         call    RestorePICMasks
          popf
          mov     dx,OFFSET Mesg_Real
          mov     ah,09h
          int     21h
          mov     bx,@data
          mov     ax,OFFSET StartData
          mov     ds,bx
          mov     dx,_PMDATA
          retf

ENDP

PROC      ConvertFlatToReal FAR

          push    bp
          mov     bp,sp
          mov     eax,[bp+6]
          mov     edx,eax
          shr     edx,4
          and     ax,000Fh
          pop     bp
          retf    0004h

ENDP

PROC      CheckForPM FAR

          smsw    ax
          and     al,1                  ;if bit 0 is set, in PM, otherwise
                                        ;in Real Mode
          retf

ENDP

PROC      GetCS   FAR

          mov     ax,cs
          retf

ENDP

PROC      GetSS   FAR

          mov     ax,_PMSTACK
          retf

ENDP

PROC      GetDS   FAR

          mov     ax,_PMDATA
          retf

ENDP

PROC      GetGDT  FAR

          mov     ax,OFFSET GDT
          mov     dx,_PMDATA
          retf

ENDP

PROC      GetGDT_Desc FAR

          mov     ax,OFFSET GDT_Desc
          mov     dx,_PMDATA
          retf

ENDP

ENDS

END

