/****************************************************************/
/* CURSES.H                                                     */
/* Header file for definitions and declarations for the         */
/* PCcurses package. This should be #include'd in all user      */
/* programs.                                                    */
/****************************************************************/
/* This version of curses is based on ncurses, a curses version */
/* originally written by Pavel Curtis at Cornell University.    */
/* I have made substantial changes to make it run on IBM PC's,  */
/* and therefore consider myself free to make it public domain. */
/*    Bjorn Larsson (...mcvax!enea!infovax!bl)                  */
/****************************************************************/
/* 1.0: Release:     870515                                     */
/* 1.1: 'Raw' output routines, revision info in                 */
/* curses.h:     880306                                         */
/* 1.2: Rcsid[] string in all modules, for maintenance: 881002  */
/* 1.3: All modules lint-checked with MSC '-W3' and             */
/* turbo'C' '-w -w-pro' switches. Support for                   */
/* border(), wborder() functions:    881005                     */
/* 1.4: Updated for MS VC++.  Also added SetWindowTitle() and   */
/* mouse routines                                               */
/****************************************************************/

#ifndef _CURSES_H
#define _CURSES_H

//Mouse button constants
#define LEFT_BUTTON     1
#define RIGHT_BUTTON    2
#define ANY_BUTTON      (LEFT_BUTTON | RIGHT_BUTTON)

//Mouse event control modes
enum    MouseEventControl {
           AUTO,                //Mouse state is always current.  It
                                //is updated whenever getting key
                                //events, checking for a keypress,
                                //or when getting the mouse state.
                                //Any keypress events found while
                                //getting the mouse state are saved
                                //in a queue.  Note that only a
                                //limited amount of keys may be saved
           SEMI_AUTO,           //When getting key events or checking
                                //for a keypress, the mouse state is
                                //updated, but calls to get the state
                                //don't automatically update the
                                //mouse state
                                //***** SEMI_AUTO is the default
                                //      startup value
           AUTO_DISCARD_KEYS }; //same as AUTO but the keypresses
                                //read while updating the mouse state
                                //are discarded

//  C++ compatible definition for  external functions

#if defined(__BCPLUSPLUS__) || defined(TCPLUSPLUS) || defined(__CPLUSPLUS__) || defined(__cplusplus)
#define _EXTERN         extern "C"
#else
#define _EXTERN         extern
#endif

// general definitions 

#define TRUE    1                // booleans 
#define FALSE   0
#define ERR     0                // general error flag 
#define OK      1                // general OK flag 

#define CURSES_RCS_ID "@(#)PCcurses v.1.3, 881005"

// functions defined as macros 

#define getch() wgetch(stdscr)           // using macroes allows you to use 
#define ungetch(c) wungetch(c)           // #undef getch/ungetch in your 

// programs to use MSC getch() and 
// ungetch() routines 

#define getyx(win,y,x)  (y = (win)->_cury, x = (win)->_curx)

#ifndef max
#define max(a,b) (((a) > (b)) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) (((a) < (b)) ? (a) : (b))
#endif

// video attribute definitions. Colour definitions for 
// CGA/EGA should also go here... 

// We will have 2 leftmost bits for attributes. These attributes are
// not colour attributes. They are to be used with wattron(), wattroff()
// and wattrset() (do bit OR with colour attributes). 

#define A_NORMAL        0x0000       //  Binary  00
#define A_HIGH          0x4000       //          01  Do not go with BLINK
#define A_BLINK         0x8000       //          10  Do not go with HIGH
#define A_REVERSE       0xC000       //          11  Overide all others
#define A_STANDOUT      A_REVERSE    //          11  Same as REVERSE

// Just for the sake of UNIX Sys5 compatibility

#define A_UNDERLINE     A_REVERSE
#define A_DIM           A_NORMAL
#define A_BOLD          A_HIGH
#define A_ALTCHARSET    A_NORMAL
#define A_CHARTEXT      0x00ff
#define A_ATTRIBUTES    0xff00


// And we have the 3 bits for background colours + 3 bits for foreground
// colours. Altogether 8 bits for EGA/VGA colours. These are colour
// attributes (not characteristics). They cannot be used with wattron()
// until the previous colour attributes have been turned off by wattroff().
// However, wattrset() will always work. 

#define F_BLACK     0x0000
#define F_BLUE      0x0100
#define F_GREEN     0x0200
#define F_CYAN      0x0300
#define F_RED       0x0400
#define F_MAGENTA   0x0500
#define F_BROWN     0x0600
#define F_GRAY      0x0700

#define B_BLACK     0x0000
#define B_BLUE      0x0800
#define B_GREEN     0x1000
#define B_CYAN      0x1800
#define B_RED       0x2000
#define B_MAGENTA   0x2800
#define B_BROWN     0x3000
#define B_GRAY      0x3800

// function and keypad key definitions. Many are just for compatibility 

#define NO_KEY         -1                // returned by wgetch() whenever
                                         // the current window is in
                                         // nodelay mode and no key is
                                         // available, i.e  no key has
                                         // been pressed
#define KEY_BREAK      0x101             // Not on PC 
#define KEY_DOWN       0x102             // The four arrow keys 
#define KEY_UP         0x103
#define KEY_LEFT       0x104
#define KEY_RIGHT      0x105
#define KEY_HOME       0x106             // Home key 
#define KEY_BACKSPACE  0x107             // Not on PC 
#define KEY_F0         0x108             // Function keys. Space for 
#define KEY_F(n)       (KEY_F0+(n))      //  64 keys is reserved. 
#define KEY_DL         0x148             // Not on PC 
#define KEY_IL         0x149             // Insert line 
#define KEY_DC         0x14a             // Delete character 
#define KEY_IC         0x14b             // Insert char or enter insert mode 
#define KEY_EIC        0x14c             // Exit insert char mode 
#define KEY_CLEAR      0x14d             // Clear screen 
#define KEY_EOS        0x14e             // Clear to end of screen 
#define KEY_EOL        0x14f             // Clear to end of line 
#define KEY_SF         0x150             // Scroll 1 line forward 
#define KEY_SR         0x151             // Scroll 1 line backwards (reverse) 
#define KEY_NPAGE      0x152             // Next page 
#define KEY_PPAGE      0x153             // Previous page 
#define KEY_STAB       0x154             // Set tab 
#define KEY_CTAB       0x155             // Clear tab 
#define KEY_CATAB      0x156             // Clear all tabs 
#define KEY_ENTER      0x157             // Enter or send (unreliable) 
#define KEY_SRESET     0x158             // soft (partial) reset (unreliable) 
#define KEY_RESET      0x159             // reset or hard reset (unreliable) 
#define KEY_PRINT      0x15a             // print or copy 
#define KEY_LL         0x15b             // home down or bottom (lower left) 
#define KEY_ABORT      0x15c             //  Abort/Terminate key (any) 
#define KEY_SHELP      0x15d             // Short help 
#define KEY_LHELP      0x15e             // Long help 

// type declarations 

typedef char bool;               // boolean type 

typedef struct
  {
  int   _cury;                   // Current pseudo-cursor 
  int   _curx;
  int   _maxy;                   // Max coordinates 
  int   _maxx;
  int   _begy;                   // Origin on screen 
  int   _begx;
  int   _flags;                  // Window properties 
  int   _attrs;                  // Attributes of written characters 
  int   _tabsize;                // Tab character size 
  //Had to rename _leave to leave for crazy MS stuff
  bool  leave;                   // Leaves cursor as it happens 
  bool  _clear;                  // Causes clear at next refresh 
  bool  _scroll;                 // Allows window scrolling 
  bool  _nodelay;                // Input character wait flag 
  bool  _keypad;                 // Flags keypad key mode active 
  int    **_line;                // Pointer to line pointer array 
  int   *_minchng;               // First changed character in line 
  int   *_maxchng;               // Last changed character in line 
  int   _regtop;                 // Top of scrolling region 
  int   _regbottom;              // Bottom of scrolling region 
  char  _borderchars[8];         // Non-std border chars 
  } WINDOW;

// For UNIX compatibility

#define	COLS	_COLS            // These are expected in UNIX
#define	LINES	_LINES

// External variables 

_EXTERN int    _LINES;            // terminal height 
_EXTERN int    _COLS;             // terminal width 
_EXTERN WINDOW *curscr;           // the current screen image 
_EXTERN WINDOW *stdscr;           // the default screen window 

// PCcurses function declarations 

_EXTERN  int addch(int);         // put char in stdscr 
_EXTERN  int addrawch(int);      // put char in stdscr, raw 
_EXTERN  int addstr(char*);      // put string in stdscr 
_EXTERN  void attrset(int);      // set stdscr char attributes 
_EXTERN  void attroff(int);      // clear attribute(a) stdscr 
_EXTERN  void attron(int);       // add attribute(s) stdscr 
_EXTERN  int baudrate(void);     // compatibility dummy 
_EXTERN  void beep(void);        // sound bell 

// Set non-std box characters 
_EXTERN  void border(int,int,int,int,int,int,int,int);
_EXTERN  void box(WINDOW*,int,int);             // draw a box around a window 
_EXTERN  void cbreak(void);                     // set terminal cbreak mode 
_EXTERN  void clear(void);                      // clear stdscr 
_EXTERN  void clearok(WINDOW*,int);             // marks a window for screen clear 
_EXTERN  int  clrtobot(void);                   // clear end of stdscr 
_EXTERN  int  clrtoeol(void);                   // clear end of line in stdscr 
_EXTERN  void crmode(void);                     // set terminal cbreak mode 
_EXTERN  void cursoff(void);                    // turns off hardware cursor 
_EXTERN  void curson(void);                     // turns on hardware cursor 
_EXTERN  void def_prog_mode(void);              // save TTY modes 
_EXTERN  void def_shell_mode(void);             // compatibility dummy 
_EXTERN  int  delch(void);                      // delete a char in stdscr 
_EXTERN  int  deleteln(void);                   // delete a line in stdscr 
_EXTERN  void delwin(WINDOW*);                  // delete a window or a subwindow 
_EXTERN  void doupdate(void);                   // update physical screen 
_EXTERN  void echo(void);                       // set terminal echo mode 
_EXTERN  int  endwin(void);                     // cleanup and finitialization 
_EXTERN  void erase(void);                      // erase stdscr 
_EXTERN  int  erasechar(void);                  // return char kill character 
_EXTERN  int  fixterm(void);                    // compatibility dummy 
_EXTERN  void flash(void);                      // flash terminal screen 
_EXTERN  void flushinp(void);                   // kill pending keyboard input 
_EXTERN  int  getstr(char*);                    // get string to stdscr and buffer 
_EXTERN  int  gettmode(void);                   // compatibility dummy 
_EXTERN  void idlok(void);                      // use ins/del line (dummy) 
_EXTERN  int  initscr(void);                    // curses initialization 
_EXTERN  int  inch(void);                       // get char at stdscr cursor 
_EXTERN  int  insch(int);                       // insert character in stdscr 
_EXTERN  int  insrawch(int);                    // insert character in stdscr, raw 
_EXTERN  int  insertln(void);                   // insert new line in stdscr 
_EXTERN  void keypad(WINDOW*,int );             // marks a window for keypad usage 
_EXTERN  int  killchar(void);                   // return line kill character 
_EXTERN  char *longname(void);                  // terminal description 
_EXTERN  void leaveok(WINDOW*,int );            // marks window for cursor 'leave' 
_EXTERN  void meta(void);                       // marks window for meta (dummy) 
_EXTERN  int  move(int,int);                    // move cursor in stdscr 
_EXTERN  int  mvaddch(int,int,int);             // move & put char in stdscr 
_EXTERN  int  mvaddrawch(int,int,int);          // move & put char in stdscr, raw 
_EXTERN  int  mvaddstr(int,int,char*);          // move & put string in stdscr 
_EXTERN  int  mvclrtobot(int,int);              // move & clear end of stdscr 
_EXTERN  int  mvclrtoeol(int,int);              // move & clear lineend in stdscr 
_EXTERN  int  mvcur(int,int,int,int);           // move terminal cursor 
_EXTERN  int  mvdelch(int,int);                 // move & delete a char in stdscr 
_EXTERN  int  mvdeleteln(int,int);              // move & delete a line in stdscr 
_EXTERN  int  mvgetch(int,int);                 // move & get char to stdscr 
_EXTERN  int  mvgetstr(int,int,char*);          // move & get string to stdscr 
_EXTERN  int  mvinch(int,int);                  // move & get char at stdscr cursor 
_EXTERN  int  mvinsch(int,int,int);             // move & insert char in stdscr 
_EXTERN  int  mvinsrawch(int,int,int);          // move & insert raw char in stdscr 
_EXTERN  int  mvinsertln(int,int);              // move & insert new line in stdscr 
_EXTERN  int  mvprintw();                       // move & print string in stdscr 
_EXTERN  int  mvscanw();                        // move & get values via stdscr 
_EXTERN  int  mvwaddch(WINDOW*,int,int,int);    // move & put char in a window 
_EXTERN  int  mvwaddrawch(WINDOW*,int,int,int); // move & put char in a window, raw 
_EXTERN  int  mvwaddstr(WINDOW*,int,int,char*); // move & put string in a window 
_EXTERN  int  mvwclrtobot(WINDOW*,int,int);     // move & clear end of a window 
_EXTERN  int  mvwclrtoeol(WINDOW*,int,int);     // move & clear lineend in a window 
_EXTERN  int  mvwdelch(WINDOW*,int,int);        // move & delete a char in a window 
_EXTERN  int  mvwdeleteln(WINDOW*,int,int);     // move & delete a line in a window 
_EXTERN  int  mvwgetch(WINDOW*,int,int);        // move & get char to a window 
_EXTERN  int  mvwgetstr(WINDOW*,int,int,char*); // move & get string to a window 
_EXTERN  int  mvwinch(WINDOW*,int,int);         // move & get char at window cursor 
_EXTERN  int  mvwinsch(WINDOW*,int,int,int);    // move & insert char in a window 
_EXTERN  int  mvwinsrawch(WINDOW*,int,int,int); // move & insert raw char in window 
_EXTERN  int  mvwinsertln(WINDOW*,int,int);     // move & insert new line in window 
_EXTERN  int  mvwin(WINDOW*,int,int);           // move window 
_EXTERN  int  mvwprintw();                      // move & print string in a window 
_EXTERN  int  mvwscanw();                       // move & get values via a window 
_EXTERN  WINDOW *newwin(int ,int,int,int);      // create a window 
_EXTERN  void nl(void);                         // set terminal cr-crlf map mode 
_EXTERN  void nocbreak(void);                   // unset terminal cbreak mode 
_EXTERN  void nocrmode(void);                   // unset terminal cbreak mode 
_EXTERN  void nodelay(WINDOW*,int );            // marks window for no input wait 
_EXTERN  void noecho(void);                     // unset terminal echo mode 
_EXTERN  void nonl(void);                       // unset terminal cr-crlf map mode 
_EXTERN  void noraw(void);                      // unset raw terminal mode 
_EXTERN  void overlay(WINDOW*,WINDOW*);         // overlay one window on another 
_EXTERN  void overwrite(WINDOW*,WINDOW*);       // overwrite one window on another 
_EXTERN  int  printw();                         // print string in stdscr 
_EXTERN  void raw(void);                        // set raw terminal mode 
_EXTERN  void refrbrk(int );                    // set screen refresh break mode 
_EXTERN  void refresh(void);                    // refresh stdscr 
_EXTERN  int  resetterm(void);                  // compatibility dummy 
_EXTERN  int  resetty(void);                    // restore terminal I/O modes 
_EXTERN  void reset_prog_mode(void);            // restore terminal I/O modes 
_EXTERN  void reset_shell_mode(void);           // set terminal to default modes 
_EXTERN  int  saveoldterm(void);                // compatibility dummy 
_EXTERN  int  saveterm(void);                   // compatibility dummy 
_EXTERN  int  savetty(void);                    // save terminal I/O modes 
_EXTERN  int  scanw();                          // get values via stdscr 
_EXTERN  void scroll(WINDOW*);                  // scroll region in a window 
_EXTERN  void scrollok(WINDOW*,int );           // marks a window to allow scroll 
_EXTERN  int  setsrcreg(void);                  // define stdscr's scroll region 
_EXTERN  int  setterm(void);                    // compatibility dummy 
_EXTERN  int  setupterm(void);                  // set up terminal (no-op) 
_EXTERN  void standend(void);                   // start normal chars in stdscr 
_EXTERN  void standout(void);                   // start standout chars in stdscr 
_EXTERN  WINDOW *subwin(WINDOW*,int ,int,int,int);      // create a sub-window 
_EXTERN  int  tabsize(int);                     // set/get tabsize of stdscr 
_EXTERN  void touchwin(WINDOW*);                // mark a window as modified 
_EXTERN  char *unctrl(int );                    // char-to-string converter 
_EXTERN  int  waddch(WINDOW*,int);              // put char in a window 
_EXTERN  int  waddrawch(WINDOW*,int);           // put char in a window, raw 
_EXTERN  int  waddstr(WINDOW*,char*);           // put string in a window 
_EXTERN  void wattroff(WINDOW*,int);            // clear attribute(a) in window 
_EXTERN  void wattron(WINDOW*,int);             // add attribute(s) in window 
_EXTERN  void wattrset(WINDOW*,int);            // set window char attributes 
_EXTERN  void wborder(WINDOW*,int ,int,int,int,int,int,int,int);                // Set non-std box characters 
_EXTERN  int  wbox(WINDOW*,int,int,int,int,int,int);    // draw a box inside a window 
_EXTERN  void wclear(WINDOW*);                  // clear a window 
_EXTERN  int  wclrtobot(WINDOW*);               // clear end of a window 
_EXTERN  int  wclrtoeol(WINDOW*);               // clear end of line in a window 
_EXTERN  int  wdelch(WINDOW*);                  // delete a char in a window 
_EXTERN  int  wdeleteln(WINDOW*);               // delete a line in a window 
_EXTERN  void werase(WINDOW*);                  // erase a window 
_EXTERN  int  wgetch(WINDOW*);                  // get char to a window 
_EXTERN  int  wgetstr(WINDOW*,char*);           // get string to window and buffer 
_EXTERN  int  winch(WINDOW*);                   // get char at window cursor 
_EXTERN  int  winsch(WINDOW*,int);              // insert character in a window 
_EXTERN  int  winsrawch(WINDOW*,int);           // insert raw character in a window 
_EXTERN  int  winsertln(WINDOW*);               // insert new line in a window 
_EXTERN  int  wmove(WINDOW*,int,int);           // move cursor in a window 
_EXTERN  void wnoutrefresh(WINDOW*);            // create screen image, w/o display 
_EXTERN  int  wprintw();                        // print string in a window 
_EXTERN  void wrefresh(WINDOW*);                // refresh screen 
_EXTERN  int  wscanw();                         // get values via a window 
_EXTERN  int  wsetsrcreg(WINDOW*,int,int);      // define a window's scroll region 
_EXTERN  void wstandend(WINDOW*);               // start normal chars in window 
_EXTERN  void wstandout(WINDOW*);               // start standout chars in window 
_EXTERN  int  wtabsize(WINDOW*,int);            // set/get tabsize of a window 
_EXTERN  int  wungetch(int);                    // character push-back 
_EXTERN  void wputatpos(WINDOW*,int ,int,int);  // put a full character code back 

#define wgetatpos(win, y, x)    (*(win->_line[y] + x))
_EXTERN  void wputatpos(WINDOW*,int,int,int);

/***************************************************************/
/* Extra routines for use with WinCurses                       */
/***************************************************************/

_EXTERN void SetWindowTitle(char *);            // Sets the window title
_EXTERN int GetMouseX(WINDOW *);                // Get current Mouse X position
                                                // relative to the upper left-
                                                // hand corner of a window
_EXTERN int GetMouseY(WINDOW *);                // Get current Mouse Y position
                                                // relative to the upper left-
                                                // hand corner of a window
_EXTERN int GetMouseButtonStatus(void);         // Get current Mouse button status
_EXTERN void ForceMouseUpdate(void);            // Causes the mouse to update its
                                                // status
_EXTERN void SetMouseEventControl(enum MouseEventControl); //sets the
                                                // method used to handle
                                                // processing of mouse
                                                // events

//  End curses.h    

#endif